<?php
// /api/newsletter/get-prospects.php
// Endpoint pour récupérer des prospects à contacter

require_once '../../admin/includes/config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://bio360.idkom.fr');
header('Access-Control-Allow-Methods: GET');

// Authentification
$auth_header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$expected_token = 'n8n_api_token_2025';
if ($auth_header !== 'Bearer ' . $expected_token) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

// Paramètres de requête
$status = $_GET['status'] ?? 'b2b_cold';
$limit = min((int)($_GET['limit'] ?? 10), 50); // Max 50 par requête
$city = $_GET['city'] ?? null;
$exclude_contacted = $_GET['exclude_contacted'] ?? 'true';

try {
    $sql = "
        SELECT c.id, c.email, c.company, c.city, c.industry, c.source, c.created_at
        FROM newsletter_contacts c
        WHERE c.consent_status = ?
    ";
    $params = [$status];
    
    // Filtrer par ville si spécifiée
    if ($city) {
        $sql .= " AND c.city = ?";
        $params[] = $city;
    }
    
    // Exclure les déjà contactés si demandé
    if ($exclude_contacted === 'true') {
        $sql .= " AND c.id NOT IN (
            SELECT DISTINCT contact_id 
            FROM newsletter_deliveries 
            WHERE status IN ('sent', 'delivered')
        )";
    }
    
    $sql .= " ORDER BY c.created_at DESC LIMIT ?";
    $params[] = $limit;
    
    $stmt = $db->prepare($sql);
    $stmt->execute($params);
    $prospects = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'count' => count($prospects),
        'prospects' => $prospects,
        'filters' => [
            'status' => $status,
            'city' => $city,
            'limit' => $limit,
            'exclude_contacted' => $exclude_contacted
        ]
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode([
        'error' => 'Database error'
    ]);
    error_log("Newsletter API Error: " . $e->getMessage());
}
?>