<?php
function requireAdminAuth() {
    if (!isLoggedIn()) {
        header('Location: login.php');
        exit;
    }
    
    // Vérifier si l'utilisateur a les droits admin
    if (!hasAdminAccess()) {
        addMessage("Accès refusé - Droits administrateur requis", "danger");
        header('Location: ../gestionstock/index.php');
        exit;
    }
}

function hasAdminAccess() {
    return isset($_SESSION['user_role']) && 
           in_array($_SESSION['user_role'], ['admin', 'super_admin']);
}

function getCurrentUser() {
    if (!isLoggedIn()) {
        return null;
    }
    
    try {
        global $db;
        $stmt = $db->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        return $stmt->fetch();
    } catch(PDOException $e) {
        error_log("Erreur lors de la récupération de l'utilisateur: " . $e->getMessage());
        return null;
    }
}
?>