<?php
require_once dirname(__FILE__) . '/includes/config.php';
require_once dirname(__FILE__) . '/includes/auth.php';

$page_title = 'Tableau de bord';

// Récupération des statistiques générales
try {
    // Stats gestion stock
    $stmt = $db->query("SELECT COUNT(*) as total_pieces FROM pieces WHERE disponible_be_matrix = 1");
    $stats_stock = $stmt->fetch();
    
    $stmt = $db->query("SELECT COUNT(*) as total_events FROM events WHERE statut != 'annule'");
    $stats_events = $stmt->fetch();
    
    $stmt = $db->query("SELECT COUNT(*) as total_stands FROM stands");
    $stats_stands = $stmt->fetch();
    
    $stmt = $db->query("SELECT COUNT(*) as total_users FROM users");
    $stats_users = $stmt->fetch();
    
    // Dernières activités
    $stmt = $db->query("
        SELECT al.*, u.prenom, u.nom 
        FROM activity_logs al 
        LEFT JOIN users u ON al.user_id = u.id 
        ORDER BY al.created_at DESC 
        LIMIT 10
    ");
    $recent_activities = $stmt->fetchAll();
    
} catch(PDOException $e) {
    error_log("Erreur lors de la récupération des stats: " . $e->getMessage());
    $stats_stock = $stats_events = $stats_stands = $stats_users = ['total' => 0];
    $recent_activities = [];
}

include 'includes/header.php';
?>

<div class="row">
    <div class="col-12">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pb-2 mb-3 border-bottom">
            <h1 class="h2">
                <i class="fas fa-tachometer-alt me-2 text-primary"></i>
                Tableau de bord
            </h1>
            <div class="btn-toolbar mb-2 mb-md-0">
                <div class="btn-group me-2">
                    <button type="button" class="btn btn-sm btn-outline-secondary">
                        <i class="fas fa-download me-1"></i>Exporter
                    </button>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Statistiques générales -->
<div class="row mb-4">
    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-primary shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                            Pièces en stock
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            <?= number_format($stats_stock['total_pieces'] ?? 0) ?>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-boxes fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-success shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                            Événements actifs
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            <?= $stats_events['total_events'] ?? 0 ?>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-calendar-alt fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-info shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                            Stands configurés
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            <?= $stats_stands['total_stands'] ?? 0 ?>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-building fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="col-xl-3 col-md-6 mb-4">
        <div class="card border-left-warning shadow h-100 py-2">
            <div class="card-body">
                <div class="row no-gutters align-items-center">
                    <div class="col mr-2">
                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                            Utilisateurs
                        </div>
                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                            <?= $stats_users['total_users'] ?? 0 ?>
                        </div>
                    </div>
                    <div class="col-auto">
                        <i class="fas fa-users fa-2x text-gray-300"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modules de gestion -->
<div class="row mb-4">
    <div class="col-12">
        <h3 class="h4 mb-3">
            <i class="fas fa-th-large me-2"></i>
            Modules de gestion
        </h3>
    </div>
    
    <?php foreach($admin_modules as $key => $module): ?>
        <?php if($module['active'] && $key != 'dashboard'): ?>
            <div class="col-lg-6 col-md-6 mb-3">
                <div class="card h-100 shadow-sm hover-shadow">
                    <div class="card-body text-center">
                        <div class="mb-3">
                            <i class="<?= $module['icon'] ?> fa-3x text-primary"></i>
                        </div>
                        <h5 class="card-title"><?= $module['name'] ?></h5>
                        <p class="card-text text-muted">
                            <?php
                            switch($key) {
                                case 'stock': echo 'Gérer les pièces, stands et événements BeMatrix'; break;
                                case 'newsletter': echo 'Créer et envoyer des newsletters à vos clients B2B'; break;
                            }
                            ?>
                        </p>
                        <a href="<?php 
                            // Gestion spéciale pour le module stock
                            if($key == 'stock') {
                                echo '/gestionstock/';
                            } else {
                                echo '/admin/' . $module['url'];
                            }
                        ?>" class="btn btn-primary">
                            <i class="fas fa-arrow-right me-1"></i>
                            Accéder
                        </a>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    <?php endforeach; ?>
</div>

<!-- Activités récentes -->
<div class="row">
    <div class="col-12">
        <div class="card shadow mb-4">
            <div class="card-header py-3">
                <h6 class="m-0 font-weight-bold text-primary">
                    <i class="fas fa-history me-1"></i>
                    Activités récentes
                </h6>
            </div>
            <div class="card-body">
                <?php if(empty($recent_activities)): ?>
                    <div class="text-center text-muted py-3">
                        <i class="fas fa-history fa-2x mb-2"></i>
                        <p>Aucune activité récente</p>
                    </div>
                <?php else: ?>
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>Date</th>
                                    <th>Utilisateur</th>
                                    <th>Action</th>
                                    <th>Détails</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($recent_activities as $activity): ?>
                                    <tr>
                                        <td>
                                            <small><?= date('d/m/Y H:i', strtotime($activity['created_at'])) ?></small>
                                        </td>
                                        <td>
                                            <?= htmlspecialchars(($activity['prenom'] ?? '') . ' ' . ($activity['nom'] ?? '')) ?>
                                        </td>
                                        <td>
                                            <span class="badge bg-info">
                                                <?= htmlspecialchars($activity['action']) ?>
                                            </span>
                                        </td>
                                        <td>
                                            <small><?= htmlspecialchars($activity['details'] ?? '') ?></small>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>