<?php
// Désactiver le cache pour éviter la page blanche
header('Cache-Control: no-cache, must-revalidate');
header('Expires: Thu, 01 Jan 1970 00:00:00 GMT');

require_once dirname(__FILE__) . '/includes/config.php';

// Si déjà connecté, redirection selon le rôle
if (isLoggedIn()) {
    if (hasAdminAccess()) {
        header('Location: index.php');
        exit;
    } else {
        // Utilisateur connecté mais pas admin, redirection vers gestion stock
        header('Location: ../gestionstock/index.php');
        exit;
    }
}

// Traitement du formulaire
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = cleanInput($_POST['username'] ?? '');
    $password = $_POST['password'] ?? '';
    
    if (!empty($username) && !empty($password)) {
        try {
            $stmt = $db->prepare("SELECT * FROM users WHERE username = ?");
            $stmt->execute([$username]);
            $user = $stmt->fetch();
            
            if ($user && password_verify($password, $user['password'])) {
                // Vérifier si l'utilisateur a les droits admin
                if (!in_array($user['role'], ['admin', 'super_admin'])) {
                    $errors['login'] = "Accès refusé - Droits administrateur requis";
                } else {
                    $_SESSION['user_id'] = $user['id'];
                    $_SESSION['user_name'] = $user['username'];
                    $_SESSION['user_role'] = $user['role'];
                    
                    // Log de connexion admin
                    error_log("Connexion admin réussie: " . $user['username'] . " (" . $user['role'] . ")");
                    
                    addMessage("Connexion administrateur réussie", "success");
                    header('Location: index.php');
                    exit;
                }
            } else {
                $errors['login'] = "Identifiants incorrects";
            }
        } catch(PDOException $e) {
            error_log("Erreur SQL connexion admin: " . $e->getMessage());
            $errors['login'] = "Erreur de connexion à la base de données";
        }
    } else {
        $errors['login'] = "Veuillez remplir tous les champs";
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Connexion Administrateur - <?= ADMIN_TITLE ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- Custom CSS -->
    <link href="<?= url('admin/assets/css/admin.css') ?>" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <!-- Logo iDkom et titre -->
                <div class="text-center mb-4">
                    <div class="mb-3">
                        <img src="../logo-idkom.png" alt="iDkom Logo" class="img-fluid mb-2" style="max-width: 120px; filter: brightness(0) invert(1);">
                        <div>
                            <i class="fas fa-shield-alt text-white" style="font-size: 3rem; opacity: 0.9;"></i>
                        </div>
                    </div>
                    <h1 class="h2 text-white fw-bold mb-2">Administration iDkom</h1>
                    <div class="admin-badge mx-auto">
                        <i class="fas fa-user-shield me-1"></i>
                        Accès Administrateur
                    </div>
                </div>
                
                <!-- Card de connexion -->
                <div class="card login-card shadow-lg">
                    <div class="card-body p-5">
                        <?php if (isset($errors['login'])): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle me-2"></i>
                                <?= $errors['login'] ?>
                            </div>
                        <?php endif; ?>

                        <form method="POST" class="needs-validation" novalidate>
                            <div class="mb-3">
                                <label for="username" class="form-label fw-semibold">
                                    <i class="fas fa-user me-1 text-primary"></i>
                                    Nom d'utilisateur
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="fas fa-user"></i>
                                    </span>
                                    <input type="text" 
                                           class="form-control" 
                                           id="username" 
                                           name="username" 
                                           value="<?= isset($_POST['username']) ? htmlspecialchars($_POST['username']) : '' ?>"
                                           required 
                                           autofocus
                                           placeholder="Saisir votre nom d'utilisateur">
                                </div>
                            </div>

                            <div class="mb-4">
                                <label for="password" class="form-label fw-semibold">
                                    <i class="fas fa-lock me-1 text-primary"></i>
                                    Mot de passe
                                </label>
                                <div class="input-group">
                                    <span class="input-group-text">
                                        <i class="fas fa-lock"></i>
                                    </span>
                                    <input type="password" 
                                           class="form-control" 
                                           id="password" 
                                           name="password" 
                                           required
                                           placeholder="Saisir votre mot de passe">
                                </div>
                            </div>

                            <button type="submit" class="btn btn-admin w-100 mb-3">
                                <i class="fas fa-sign-in-alt me-2"></i>
                                Accéder à l'administration
                            </button>
                        </form>
                        
                        <hr class="my-4">
                        
                        <div class="text-center">
                            <small class="text-muted">
                                <i class="fas fa-info-circle me-1"></i>
                                Accès réservé aux administrateurs autorisés
                            </small>
                            <div class="mt-2">
                                <a href="../gestionstock/" class="text-decoration-none">
                                    <small>
                                        <i class="fas fa-arrow-left me-1"></i>
                                        Retour à la gestion de stock
                                    </small>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
                
                <!-- Modules disponibles (aperçu) -->
                <div class="text-center mt-4">
                    <small class="text-white-50">
                        <i class="fas fa-tools me-1"></i>
                        Modules : Gestion Stock • Newsletter
                    </small>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>