<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once dirname(__FILE__) . '/../../../includes/config.php';
require_once dirname(__FILE__) . '/../../../includes/auth.php';

$page_title = 'Éditeur Newsletter';
requireAdminAuth();

require_once dirname(__FILE__) . '/../../../includes/header.php';
?>

<style>
.editor-header {
    background: linear-gradient(135deg, #6f42c1 0%, #e83e8c 100%);
    color: white;
    padding: 2rem 0;
    margin-bottom: 2rem;
}

.editor-toolbar {
    background: #f8f9fa;
    border-radius: 8px;
    padding: 1rem;
    margin-bottom: 1rem;
    border: 1px solid #dee2e6;
}

.code-editor {
    font-family: 'Monaco', 'Menlo', 'Ubuntu Mono', monospace;
    font-size: 14px;
    border-radius: 8px;
    border: 1px solid #dee2e6;
}

.preview-frame {
    border: 1px solid #dee2e6;
    border-radius: 8px;
    background: white;
    min-height: 600px;
}

.element-btn {
    margin: 0.25rem;
    padding: 0.5rem 1rem;
    border: 1px solid #dee2e6;
    background: white;
    cursor: pointer;
    border-radius: 4px;
    transition: all 0.2s;
}

.element-btn:hover {
    background: #e9ecef;
    border-color: #0d6efd;
}

.color-palette {
    display: flex;
    gap: 0.5rem;
    margin: 0.5rem 0;
}

.color-option {
    width: 30px;
    height: 30px;
    border-radius: 50%;
    cursor: pointer;
    border: 2px solid #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}
</style>

<div class="editor-header">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-md-8">
                <h1><i class="fas fa-code me-3"></i>Éditeur Newsletter</h1>
                <p class="mb-0">Créez votre newsletter avec aperçu en temps réel</p>
            </div>
            <div class="col-md-4 text-end">
                <button class="btn btn-light me-2" onclick="saveTemplate()">
                    <i class="fas fa-save me-1"></i>Sauvegarder
                </button>
                <a href="create.php" class="btn btn-outline-light">
                    <i class="fas fa-arrow-left me-1"></i>Retour
                </a>
            </div>
        </div>
    </div>
</div>

<div class="container-fluid">
    <div class="row">
        <!-- Panneau gauche : Outils -->
        <div class="col-md-3">
            <div class="card">
                <div class="card-header">
                    <h6><i class="fas fa-tools me-2"></i>Éléments</h6>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <small class="text-muted">STRUCTURE</small>
                        <div class="d-grid gap-1 mt-2">
                            <button class="element-btn" onclick="addElement('header')">
                                <i class="fas fa-heading me-2"></i>En-tête
                            </button>
                            <button class="element-btn" onclick="addElement('text')">
                                <i class="fas fa-paragraph me-2"></i>Texte
                            </button>
                            <button class="element-btn" onclick="addElement('image')">
                                <i class="fas fa-image me-2"></i>Image
                            </button>
                            <button class="element-btn" onclick="addElement('button')">
                                <i class="fas fa-square me-2"></i>Bouton
                            </button>
                            <button class="element-btn" onclick="addElement('separator')">
                                <i class="fas fa-minus me-2"></i>Séparateur
                            </button>
                        </div>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted">CONTENU</small>
                        <div class="d-grid gap-1 mt-2">
                            <button class="element-btn" onclick="addElement('intro')">
                                <i class="fas fa-hand-wave me-2"></i>Introduction
                            </button>
                            <button class="element-btn" onclick="addElement('news')">
                                <i class="fas fa-newspaper me-2"></i>Actualité
                            </button>
                            <button class="element-btn" onclick="addElement('promo')">
                                <i class="fas fa-tag me-2"></i>Promotion
                            </button>
                            <button class="element-btn" onclick="addElement('footer')">
                                <i class="fas fa-signature me-2"></i>Pied de page
                            </button>
                        </div>
                    </div>

                    <div class="mb-3">
                        <small class="text-muted">COULEURS</small>
                        <div class="color-palette">
                            <div class="color-option" style="background: #0d6efd" onclick="setColor('#0d6efd')"></div>
                            <div class="color-option" style="background: #198754" onclick="setColor('#198754')"></div>
                            <div class="color-option" style="background: #dc3545" onclick="setColor('#dc3545')"></div>
                            <div class="color-option" style="background: #fd7e14" onclick="setColor('#fd7e14')"></div>
                            <div class="color-option" style="background: #6f42c1" onclick="setColor('#6f42c1')"></div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="card mt-3">
                <div class="card-header">
                    <h6><i class="fas fa-palette me-2"></i>Templates prêts</h6>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <button class="btn btn-outline-primary btn-sm" onclick="loadTemplate('business')">
                            Business
                        </button>
                        <button class="btn btn-outline-success btn-sm" onclick="loadTemplate('promo')">
                            Promotion
                        </button>
                        <button class="btn btn-outline-info btn-sm" onclick="loadTemplate('news')">
                            Newsletter
                        </button>
                        <button class="btn btn-outline-warning btn-sm" onclick="loadTemplate('minimal')">
                            Minimal
                        </button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Panneau central : Code -->
        <div class="col-md-4">
            <div class="editor-toolbar">
                <div class="btn-group btn-group-sm me-3">
                    <button class="btn btn-outline-secondary" onclick="formatCode()">
                        <i class="fas fa-code me-1"></i>Formater
                    </button>
                    <button class="btn btn-outline-secondary" onclick="clearEditor()">
                        <i class="fas fa-trash me-1"></i>Vider
                    </button>
                </div>
                <button class="btn btn-primary btn-sm" onclick="updatePreview()">
                    <i class="fas fa-eye me-1"></i>Aperçu
                </button>
            </div>

            <textarea id="htmlEditor" class="form-control code-editor" rows="25" placeholder="Votre code HTML apparaîtra ici..."><!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Newsletter iDkom</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 0; padding: 20px; background: #f5f5f5; }
        .container { max-width: 600px; margin: 0 auto; background: white; }
        .header { background: #0d6efd; color: white; padding: 20px; text-align: center; }
        .content { padding: 20px; }
        .button { display: inline-block; padding: 12px 24px; background: #0d6efd; color: white; text-decoration: none; border-radius: 4px; }
        .footer { background: #f8f9fa; padding: 15px; text-align: center; font-size: 12px; color: #666; }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>Newsletter iDkom</h1>
        </div>
        <div class="content">
            <p>Cliquez sur les éléments à gauche pour construire votre newsletter...</p>
        </div>
        <div class="footer">
            <p>© 2025 iDkom - Tous droits réservés</p>
        </div>
    </div>
</body>
</html></textarea>

            <div class="mt-3">
                <button class="btn btn-success w-100" onclick="copyToClipboard()">
                    <i class="fas fa-copy me-2"></i>Copier le HTML
                </button>
            </div>
        </div>

        <!-- Panneau droit : Aperçu -->
        <div class="col-md-5">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h6><i class="fas fa-eye me-2"></i>Aperçu en temps réel</h6>
                    <div class="btn-group btn-group-sm">
                        <button class="btn btn-outline-secondary" onclick="setPreviewMode('desktop')">
                            <i class="fas fa-desktop"></i>
                        </button>
                        <button class="btn btn-outline-secondary" onclick="setPreviewMode('mobile')">
                            <i class="fas fa-mobile-alt"></i>
                        </button>
                    </div>
                </div>
                <div class="card-body p-0">
                    <iframe id="previewFrame" class="preview-frame w-100" style="height: 600px;"></iframe>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
let currentColor = '#0d6efd';

// Mettre à jour l'aperçu automatiquement
const editor = document.getElementById('htmlEditor');
editor.addEventListener('input', debounce(updatePreview, 500));

// Initialiser l'aperçu
updatePreview();

function updatePreview() {
    const iframe = document.getElementById('previewFrame');
    const content = editor.value;
    
    iframe.srcdoc = content;
}

function addElement(type) {
    const cursor = editor.selectionStart;
    let htmlToInsert = '';
    
    switch(type) {
        case 'header':
            htmlToInsert = `
        <div class="header" style="background: ${currentColor}; color: white; padding: 20px; text-align: center;">
            <h1>Votre Titre</h1>
            <p>Sous-titre ou description</p>
        </div>`;
            break;
            
        case 'text':
            htmlToInsert = `
        <div style="padding: 20px;">
            <h2>Titre de section</h2>
            <p>Votre contenu texte ici. Vous pouvez ajouter plusieurs paragraphes et du <strong>texte en gras</strong> ou en <em>italique</em>.</p>
        </div>`;
            break;
            
        case 'image':
            htmlToInsert = `
        <div style="text-align: center; padding: 20px;">
            <img src="https://via.placeholder.com/400x200" alt="Description image" style="max-width: 100%; height: auto; border-radius: 8px;">
            <p style="font-size: 14px; color: #666; margin-top: 10px;">Légende de l'image</p>
        </div>`;
            break;
            
        case 'button':
            htmlToInsert = `
        <div style="text-align: center; padding: 20px;">
            <a href="#" class="button" style="display: inline-block; padding: 12px 24px; background: ${currentColor}; color: white; text-decoration: none; border-radius: 4px;">
                Votre Call-to-Action
            </a>
        </div>`;
            break;
            
        case 'separator':
            htmlToInsert = `
        <div style="padding: 20px;">
            <hr style="border: none; border-top: 2px solid #eee; margin: 20px 0;">
        </div>`;
            break;
            
        case 'intro':
            htmlToInsert = `
        <div style="padding: 20px; background: #f8f9fa;">
            <h2>Bonjour {{firstname}},</h2>
            <p>Nous espérons que vous allez bien. Voici les dernières actualités de notre équipe :</p>
        </div>`;
            break;
            
        case 'news':
            htmlToInsert = `
        <div style="padding: 20px; border-left: 4px solid ${currentColor}; margin: 20px;">
            <h3 style="color: ${currentColor};">Actualité importante</h3>
            <p>Description de votre actualité ou nouveauté. Ajoutez les détails importants ici.</p>
            <a href="#" style="color: ${currentColor};">Lire la suite →</a>
        </div>`;
            break;
            
        case 'promo':
            htmlToInsert = `
        <div style="background: linear-gradient(135deg, ${currentColor}, #fd7e14); color: white; padding: 20px; text-align: center; margin: 20px 0; border-radius: 8px;">
            <h2 style="margin: 0;">Offre Spéciale !</h2>
            <p style="font-size: 18px; margin: 10px 0;">-20% sur tous nos services</p>
            <a href="#" style="display: inline-block; padding: 12px 24px; background: white; color: ${currentColor}; text-decoration: none; border-radius: 4px; font-weight: bold;">
                Profiter de l'offre
            </a>
        </div>`;
            break;
            
        case 'footer':
            htmlToInsert = `
        <div class="footer" style="background: #f8f9fa; padding: 15px; text-align: center; font-size: 12px; color: #666;">
            <p><strong>iDkom</strong><br>
            Votre adresse<br>
            Téléphone : XX XX XX XX XX</p>
            <p>
                <a href="#" style="color: #666;">Se désabonner</a> | 
                <a href="#" style="color: #666;">Voir en ligne</a>
            </p>
        </div>`;
            break;
    }
    
    // Insérer au curseur
    const beforeCursor = editor.value.substring(0, cursor);
    const afterCursor = editor.value.substring(cursor);
    editor.value = beforeCursor + htmlToInsert + afterCursor;
    
    // Mettre à jour l'aperçu
    updatePreview();
}

function setColor(color) {
    currentColor = color;
    
    // Mettre à jour visuellement la couleur sélectionnée
    document.querySelectorAll('.color-option').forEach(option => {
        option.style.border = '2px solid #fff';
    });
    event.target.style.border = '2px solid #333';
}

function loadTemplate(type) {
    let template = '';
    
    switch(type) {
        case 'business':
            template = `<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Newsletter Business</title>
    <style>
        body { font-family: 'Segoe UI', Arial, sans-serif; margin: 0; padding: 20px; background: #f5f5f5; }
        .container { max-width: 600px; margin: 0 auto; background: white; box-shadow: 0 4px 8px rgba(0,0,0,0.1); }
    </style>
</head>
<body>
    <div class="container">
        <div style="background: #2c5aa0; color: white; padding: 30px; text-align: center;">
            <h1 style="margin: 0; font-size: 28px;">iDkom Business</h1>
            <p style="margin: 10px 0 0 0; opacity: 0.9;">Newsletter professionnelle</p>
        </div>
        <div style="padding: 30px;">
            <h2 style="color: #2c5aa0;">Cher partenaire,</h2>
            <p>Nous avons le plaisir de partager avec vous nos dernières actualités business.</p>
        </div>
    </div>
</body>
</html>`;
            break;
            
        case 'promo':
            template = `<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Offre Spéciale</title>
</head>
<body style="font-family: Arial, sans-serif; margin: 0; padding: 20px; background: #f5f5f5;">
    <div style="max-width: 600px; margin: 0 auto; background: white;">
        <div style="background: linear-gradient(135deg, #dc3545, #fd7e14); color: white; padding: 40px; text-align: center;">
            <h1 style="margin: 0; font-size: 32px;">🔥 OFFRE LIMITÉE</h1>
            <p style="font-size: 20px; margin: 15px 0 0 0;">Ne manquez pas cette opportunité !</p>
        </div>
        <div style="padding: 30px; text-align: center;">
            <h2>-50% sur tous nos services</h2>
            <a href="#" style="display: inline-block; padding: 15px 30px; background: #dc3545; color: white; text-decoration: none; border-radius: 6px; font-size: 18px; font-weight: bold;">
                PROFITER MAINTENANT
            </a>
        </div>
    </div>
</body>
</html>`;
            break;
            
        case 'news':
            template = `<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Newsletter Actualités</title>
</head>
<body style="font-family: Georgia, serif; margin: 0; padding: 20px; background: #f8f9fa;">
    <div style="max-width: 600px; margin: 0 auto; background: white; border-radius: 8px; overflow: hidden;">
        <div style="background: #198754; color: white; padding: 25px;">
            <h1 style="margin: 0;">📰 Actualités iDkom</h1>
        </div>
        <div style="padding: 25px;">
            <article style="border-bottom: 1px solid #eee; padding-bottom: 20px; margin-bottom: 20px;">
                <h2 style="color: #198754;">Titre de l'actualité</h2>
                <p>Contenu de votre actualité...</p>
            </article>
        </div>
    </div>
</body>
</html>`;
            break;
            
        case 'minimal':
            template = `<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Newsletter Minimale</title>
</head>
<body style="font-family: 'Helvetica Neue', Arial, sans-serif; margin: 0; padding: 40px; background: white; color: #333;">
    <div style="max-width: 500px; margin: 0 auto;">
        <h1 style="font-weight: 300; font-size: 24px; border-bottom: 1px solid #eee; padding-bottom: 20px;">iDkom</h1>
        <div style="padding: 30px 0;">
            <p>Message simple et élégant.</p>
            <p>Minimal mais efficace.</p>
        </div>
        <div style="border-top: 1px solid #eee; padding-top: 20px; font-size: 12px; color: #999;">
            <p>iDkom © 2025</p>
        </div>
    </div>
</body>
</html>`;
            break;
    }
    
    editor.value = template;
    updatePreview();
}

function formatCode() {
    // Simple formatage (ajout de retours à la ligne)
    let formatted = editor.value
        .replace(/></g, '>\n<')
        .replace(/\s+/g, ' ')
        .trim();
    
    editor.value = formatted;
    updatePreview();
}

function clearEditor() {
    if (confirm('Êtes-vous sûr de vouloir vider l\'éditeur ?')) {
        editor.value = '';
        updatePreview();
    }
}

function copyToClipboard() {
    editor.select();
    document.execCommand('copy');
    
    // Feedback visuel
    const btn = event.target;
    const originalText = btn.innerHTML;
    btn.innerHTML = '<i class="fas fa-check me-2"></i>Copié !';
    btn.classList.remove('btn-success');
    btn.classList.add('btn-success');
    
    setTimeout(() => {
        btn.innerHTML = originalText;
    }, 2000);
}

function setPreviewMode(mode) {
    const iframe = document.getElementById('previewFrame');
    if (mode === 'mobile') {
        iframe.style.width = '375px';
        iframe.style.margin = '0 auto';
    } else {
        iframe.style.width = '100%';
        iframe.style.margin = '0';
    }
}

function saveTemplate() {
    // Ici on pourrait sauvegarder en base
    alert('Fonctionnalité de sauvegarde à implémenter selon vos besoins');
}

// Fonction utilitaire debounce
function debounce(func, wait) {
    let timeout;
    return function executedFunction(...args) {
        const later = () => {
            clearTimeout(timeout);
            func(...args);
        };
        clearTimeout(timeout);
        timeout = setTimeout(later, wait);
    };
}
</script>

<?php require_once dirname(__FILE__) . '/../../../includes/footer.php'; ?>