<?php
// /api/newsletter/mark-contacted.php
// Endpoint pour marquer un prospect comme contacté

require_once '../../admin/includes/config.php';

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: https://bio360.idkom.fr');
header('Access-Control-Allow-Methods: POST');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['error' => 'Method not allowed']);
    exit;
}

// Authentification
$auth_header = $_SERVER['HTTP_AUTHORIZATION'] ?? '';
$expected_token = 'n8n_api_token_2025';
if ($auth_header !== 'Bearer ' . $expected_token) {
    http_response_code(401);
    echo json_encode(['error' => 'Unauthorized']);
    exit;
}

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || !isset($data['contact_id']) || !isset($data['campaign_name'])) {
    http_response_code(400);
    echo json_encode(['error' => 'Missing contact_id or campaign_name']);
    exit;
}

$contact_id = (int)$data['contact_id'];
$campaign_name = $data['campaign_name'];
$message_id = $data['message_id'] ?? 'n8n_' . uniqid();

try {
    // Créer une entrée de livraison
    $stmt = $db->prepare("
        INSERT INTO newsletter_deliveries 
        (campaign_id, contact_id, message_id, status, sent_at)
        VALUES (0, ?, ?, 'sent', NOW())
    ");
    $stmt->execute([$contact_id, $message_id]);
    
    echo json_encode([
        'success' => true,
        'contact_id' => $contact_id,
        'message' => 'Contact marqué comme envoyé'
    ]);
    
} catch (PDOException $e) {
    http_response_code(500);
    echo json_encode(['error' => 'Database error']);
    error_log("Newsletter API Error: " . $e->getMessage());
}
?>