<?php
// =========================================
// FICHIER: /gestionstock/clients/actions.php
// Actions CRUD complètes pour les clients
// =========================================

require_once '../includes/init.php';

if (!isset($_REQUEST['action'])) {
    header('Location: index.php');
    exit;
}

$action = $_REQUEST['action'];

try {
    switch($action) {
        case 'create':
            $sql = "INSERT INTO clients (
                societe, 
                pays,
                contact_commercial_nom, 
                contact_commercial_prenom, 
                contact_commercial_mail, 
                contact_commercial_tel,
                contact_terrain_nom, 
                contact_terrain_prenom,
                contact_terrain_mail, 
                contact_terrain_tel,
                dropbox_url, 
                becad_url, 
                notes_internes,
                langue_communication,
                statut,
                created_at
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'client_actif', NOW())";
            
            $db->prepare($sql)->execute([
                $_POST['societe'],
                $_POST['pays'] ?? 'France',
                $_POST['contact_commercial_nom'],
                $_POST['contact_commercial_prenom'], 
                $_POST['contact_commercial_mail'],
                $_POST['contact_commercial_tel'] ?? null,
                $_POST['contact_terrain_nom'] ?? null,
                $_POST['contact_terrain_prenom'] ?? null,
                $_POST['contact_terrain_mail'] ?? null,
                $_POST['contact_terrain_tel'] ?? null,
                $_POST['dropbox_url'] ?? null,
                $_POST['becad_url'] ?? null,
                $_POST['notes_internes'] ?? null,
                $_POST['langue_communication'] ?? 'fr'
            ]);
            
            // Log de l'activité
            $client_id = $db->lastInsertId();
            logActivity($db, 'create_client', "Nouveau client créé: {$_POST['societe']}", null, $client_id);
            
            $_SESSION['success'] = "Client \"{$_POST['societe']}\" créé avec succès !";
            break;

        case 'update':
            $sql = "UPDATE clients SET 
                societe = ?, 
                pays = ?,
                contact_commercial_nom = ?, 
                contact_commercial_prenom = ?, 
                contact_commercial_mail = ?, 
                contact_commercial_tel = ?,
                contact_terrain_nom = ?, 
                contact_terrain_prenom = ?,
                contact_terrain_mail = ?, 
                contact_terrain_tel = ?,
                dropbox_url = ?, 
                becad_url = ?, 
                notes_internes = ?,
                langue_communication = ?,
                updated_at = NOW()
            WHERE id = ?";
            
            $db->prepare($sql)->execute([
                $_POST['societe'],
                $_POST['pays'],
                $_POST['contact_commercial_nom'],
                $_POST['contact_commercial_prenom'], 
                $_POST['contact_commercial_mail'],
                $_POST['contact_commercial_tel'],
                $_POST['contact_terrain_nom'],
                $_POST['contact_terrain_prenom'],
                $_POST['contact_terrain_mail'],
                $_POST['contact_terrain_tel'],
                $_POST['dropbox_url'],
                $_POST['becad_url'],
                $_POST['notes_internes'],
                $_POST['langue_communication'],
                $_POST['id']
            ]);
            
            // Log de l'activité
            logActivity($db, 'update_client', "Client modifié: {$_POST['societe']}", null, $_POST['id']);
            
            $_SESSION['success'] = "Client \"{$_POST['societe']}\" modifié avec succès !";
            break;

        case 'delete':
            // Récupérer le nom du client avant suppression
            $client = $db->prepare("SELECT societe FROM clients WHERE id = ?");
            $client->execute([$_GET['id']]);
            $client_data = $client->fetch();
            
            if (!$client_data) {
                throw new Exception('Client introuvable');
            }
            
            // Vérifier s'il y a des stands liés
            $stands_count = $db->prepare("SELECT COUNT(*) FROM stands WHERE client_id = ?");
            $stands_count->execute([$_GET['id']]);
            $nb_stands = $stands_count->fetchColumn();
            
            if ($nb_stands > 0) {
                // Dissocier les stands au lieu de bloquer la suppression
                $db->prepare("UPDATE stands SET client_id = NULL WHERE client_id = ?")->execute([$_GET['id']]);
                $message_stands = " ($nb_stands stand" . ($nb_stands > 1 ? 's' : '') . " dissocié" . ($nb_stands > 1 ? 's' : '') . ")";
            } else {
                $message_stands = "";
            }
            
            // Supprimer le client
            $db->prepare("DELETE FROM clients WHERE id = ?")->execute([$_GET['id']]);
            
            // Log de l'activité
            logActivity($db, 'delete_client', "Client supprimé: {$client_data['societe']}{$message_stands}");
            
            $_SESSION['success'] = "Client \"{$client_data['societe']}\" supprimé avec succès !{$message_stands}";
            break;

        case 'get':
            // API pour récupérer les données d'un client (pour l'édition)
            if (!isset($_GET['id'])) {
                http_response_code(400);
                echo json_encode(['error' => 'ID manquant']);
                exit;
            }
            
            $sql = "SELECT * FROM clients WHERE id = ?";
            $stmt = $db->prepare($sql);
            $stmt->execute([$_GET['id']]);
            $client = $stmt->fetch(PDO::FETCH_ASSOC);
            
            if (!$client) {
                http_response_code(404);
                echo json_encode(['error' => 'Client introuvable']);
                exit;
            }
            
            header('Content-Type: application/json');
            echo json_encode($client);
            exit;

        default:
            throw new Exception('Action non reconnue');
    }
    
} catch(Exception $e) {
    $_SESSION['error'] = 'Erreur : ' . $e->getMessage();
}

header('Location: index.php');
exit;

// =========================================
// FONCTION UTILITAIRE POUR LES LOGS
// =========================================
function logActivity($db, $action, $details, $user_id = null, $event_id = null) {
    try {
        $sql = "INSERT INTO activity_logs (user_id, event_id, action, details, ip_address, created_at) 
                VALUES (?, ?, ?, ?, ?, NOW())";
        $db->prepare($sql)->execute([
            $user_id,
            $event_id, 
            $action,
            $details,
            $_SERVER['REMOTE_ADDR'] ?? null
        ]);
    } catch(Exception $e) {
        // Log silencieux - ne pas interrompre le flux principal
    }
}
?>