<?php
// Créer ce fichier : /clients/quick_create.php

require_once '../includes/init.php';
requireLogin();

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Méthode non autorisée']);
    exit;
}

try {
    $db->beginTransaction();
    
    // Validation des données
    $errors = [];
    
    if (empty($_POST['societe'])) {
        $errors[] = "Le nom de la société est requis";
    }
    
    $email = $_POST['contact_commercial_mail'] ?? '';
    if (empty($email)) {
        // Générer un email par défaut si non fourni
        $societe_clean = strtolower(preg_replace('/[^a-zA-Z0-9]/', '', $_POST['societe']));
        $email = 'contact@' . $societe_clean . '.com';
    }
    
    // Vérifier si la société existe déjà
    $stmt = $db->prepare("SELECT id FROM clients WHERE societe = ?");
    $stmt->execute([$_POST['societe']]);
    if ($stmt->fetch()) {
        $errors[] = "Cette société existe déjà";
    }
    
    // Vérifier si l'email existe déjà (seulement si fourni explicitement)
    if (!empty($_POST['contact_commercial_mail'])) {
        $stmt = $db->prepare("SELECT id FROM clients WHERE contact_commercial_mail = ?");
        $stmt->execute([$_POST['contact_commercial_mail']]);
        if ($stmt->fetch()) {
            $errors[] = "Cet email est déjà utilisé";
        }
    }
    
    if (!empty($errors)) {
        throw new Exception(implode(', ', $errors));
    }
    
    // Insertion du client
    $stmt = $db->prepare("
        INSERT INTO clients (
            societe,
            secteur_activite,
            contact_commercial_nom,
            contact_commercial_prenom,
            contact_commercial_mail,
            statut,
            created_at,
            updated_at
        ) VALUES (
            :societe,
            :secteur_activite,
            :contact_commercial_nom,
            :contact_commercial_prenom,
            :contact_commercial_mail,
            :statut,
            NOW(),
            NOW()
        )
    ");
    
    $stmt->execute([
        'societe' => $_POST['societe'],
        'secteur_activite' => $_POST['secteur_activite'] ?? null,
        'contact_commercial_nom' => $_POST['contact_commercial_nom'] ?? '',
        'contact_commercial_prenom' => $_POST['contact_commercial_prenom'] ?? '',
        'contact_commercial_mail' => $email,
        'statut' => $_POST['statut'] ?? 'prospect'
    ]);
    
    $client_id = $db->lastInsertId();
    
    // Log de l'action
    $stmt = $db->prepare("
        INSERT INTO activity_logs (
            user_id, 
            action, 
            details, 
            created_at
        ) VALUES (?, 'CREATE', ?, NOW())
    ");
    
    $logDetails = "Création rapide du client '{$_POST['societe']}'";
    $stmt->execute([$_SESSION['user_id'], $logDetails]);
    
    $db->commit();
    
    echo json_encode([
        'success' => true, 
        'client_id' => $client_id,
        'message' => 'Client créé avec succès'
    ]);
    
} catch (Exception $e) {
    $db->rollBack();
    error_log("Erreur lors de la création rapide du client : " . $e->getMessage());
    
    http_response_code(400);
    echo json_encode([
        'success' => false, 
        'message' => $e->getMessage()
    ]);
}
?>