<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo SITE_NAME; ?></title>
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.1/css/all.min.css">
    <!-- Custom CSS -->
    <link href="<?php echo url('assets/css/style.css'); ?>" rel="stylesheet">
    
    <!-- CSS spécifique au tri des tableaux -->
    <?php if (strpos($_SERVER['REQUEST_URI'], 'pieces.php') !== false): ?>
        <link rel="stylesheet" href="<?= url('assets/css/table-sort.css') ?>">
    <?php endif; ?>
    
    <!-- Chart.js pour les graphiques -->
    <?php if (strpos($_SERVER['REQUEST_URI'], 'pieces.php') !== false): ?>
        <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
        <!-- Données pour les graphiques -->
        <?php if (isset($chartData)): ?>
            <script>
                const chartData = <?= json_encode($chartData) ?>;
            </script>
        <?php endif; ?>
    <?php endif; ?>
    
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    
    <!-- Style personnalisé pour les messages -->
    <style>
        .messages-container {
            position: fixed;
            top: 20px;
            right: 20px;
            z-index: 1050;
            max-width: 400px;
        }
        
        .alert {
            margin-bottom: 10px;
            box-shadow: 0 2px 5px rgba(0,0,0,0.2);
            animation: slideIn 0.5s ease-out;
        }
        
        @keyframes slideIn {
            from {
                transform: translateX(100%);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        
        .alert-dismissible .btn-close {
            padding: 0.75rem;
        }

        /* Animation pour les lignes */
        tr {
            transition: all 0.3s ease-out;
        }

        /* Animation pour le fade */
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .fade-in-row {
            animation: fadeIn 0.3s ease-out;
        }

        /* Indicateur de chargement */
        .loading-overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(255, 255, 255, 0.8);
            display: flex;
            justify-content: center;
            align-items: center;
            z-index: 1000;
            display: none;
        }

        .loading-spinner {
            width: 40px;
            height: 40px;
            border: 4px solid #f3f3f3;
            border-top: 4px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
    </style>
</head>
<body>
    <!-- Affichage des messages avec filtrage -->
    <?php 
    $messages = getMessages();
    if (!empty($messages)): 
        // Filtrer les messages pour exclure le message d'erreur spécifique
        $filtered_messages = array_filter($messages, function($message) {
            return $message['text'] !== "Erreur lors de la récupération des statistiques";
        });
        
        // N'afficher le conteneur que s'il reste des messages après filtrage
        if (!empty($filtered_messages)):
    ?>
        <div class="container mt-3">
            <?php foreach ($filtered_messages as $message): ?>
                <div class="alert alert-<?php echo e($message['type']); ?> alert-dismissible fade show" role="alert">
                    <?php echo e($message['text']); ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endforeach; ?>
        </div>
    <?php 
        endif;
    endif; 
    ?>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark">
        <div class="container-fluid">
            <a class="navbar-brand" href="<?php echo url(); ?>">
                <img src="<?php echo url('assets/img/logo.png'); ?>" alt="iDkom" height="30">
            </a>
            
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav">
                    <!-- Catalogue - Visible pour tous -->
                    <li class="nav-item">
                        <a class="nav-link" href="<?php echo url('stock/catalogue.php'); ?>">
                            <i class="fas fa-boxes me-1"></i> Catalogue
                        </a>
                    </li>

                    <?php if (isLoggedIn()): ?>
                        <!-- NOUVEAU : Menu Clients -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-building me-1"></i> Clients
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo url('clients/'); ?>">
                                    <i class="fas fa-list me-2"></i>Liste des clients
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo url('clients/'); ?>#nouveau-client" onclick="$('#modalClient').modal('show');">
                                    <i class="fas fa-plus me-2"></i>Nouveau client
                                </a></li>
                            </ul>
                        </li>

                        <!-- Événements -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-calendar-alt me-1"></i> Événements
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo url('events/planning.php'); ?>">
                                    <i class="fas fa-calendar-week me-2"></i>Planning
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo url('events/liste.php'); ?>">
                                    <i class="fas fa-list me-2"></i>Liste
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo url('events/creation.php'); ?>">
                                    <i class="fas fa-plus me-2"></i>Nouvel événement
                                </a></li>
                            </ul>
                        </li>

                        <!-- Stands -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-store me-1"></i> Stands
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo url('stand/liste.php'); ?>">
                                    <i class="fas fa-store-alt me-2"></i>Liste des stands
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo url('stand/creation.php'); ?>">
                                    <i class="fas fa-plus me-2"></i>Ajouter un stand
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo url('stand/categories/index.php'); ?>">
                                    <i class="fas fa-tags me-2"></i>Types de stands
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo url('stand_options/liste.php'); ?>">
                                    <i class="fas fa-cubes me-2"></i>Options de stands
                                </a></li>
                            </ul>
                        </li>

                        <!-- Stock -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-box me-1"></i> Stock
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo url('stock/pieces.php'); ?>">
                                    <i class="fas fa-cubes me-2"></i>Liste des pièces
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo url('stock/pieces-ajout.php'); ?>">
                                    <i class="fas fa-plus me-2"></i>Ajouter une pièce
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo url('scans/index.php'); ?>">
                                    <i class="fas fa-qrcode me-2"></i>Scanner QR Code
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo url('scans/generate.php'); ?>">
                                    <i class="fas fa-barcode me-2"></i>Générer QR Code
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo url('stock/stock-planning.php'); ?>">
                                    <i class="fas fa-calendar-alt me-2"></i>Planning des stocks
                                </a></li>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item" href="<?php echo url('admin/categories.php'); ?>">
                                    <i class="fas fa-tags me-2"></i>Catégories de pièces
                                </a></li>
                            </ul>
                        </li>

                        <!-- Mouvements -->
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-exchange-alt me-1"></i> Mouvements
                            </a>
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="<?php echo url('mouvements/entree.php'); ?>">
                                    <i class="fas fa-download me-2"></i>Entrée
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo url('mouvements/sortie.php'); ?>">
                                    <i class="fas fa-upload me-2"></i>Sortie
                                </a></li>
                                <li><a class="dropdown-item" href="<?php echo url('mouvements/inventaire.php'); ?>">
                                    <i class="fas fa-clipboard-check me-2"></i>Inventaire
                                </a></li>
                            </ul>
                        </li>
                    <?php endif; ?>
                </ul>
                
                <!-- Menu utilisateur -->
                <ul class="navbar-nav ms-auto">
                    <?php if (isLoggedIn()): ?>
                        <li class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown">
                                <i class="fas fa-user me-1"></i> Mon Compte
                            </a>
                            <ul class="dropdown-menu dropdown-menu-end">
                                <li><a class="dropdown-item" href="<?php echo url('profil.php'); ?>">
                                    <i class="fas fa-id-card me-2"></i>Profil
                                </a></li>
                                <?php if (isAdmin()): ?>
                                    <li><hr class="dropdown-divider"></li>
                                    <li><a class="dropdown-item text-primary" href="<?php echo url('admin/users.php'); ?>">
                                        <i class="fas fa-users-cog me-2"></i>Gestion utilisateurs
                                    </a></li>
                                <?php endif; ?>
                                <li><hr class="dropdown-divider"></li>
                                <li><a class="dropdown-item text-danger" href="<?php echo url('logout.php'); ?>">
                                    <i class="fas fa-sign-out-alt me-2"></i>Déconnexion
                                </a></li>
                            </ul>
                        </li>
                    <?php else: ?>
                        <li class="nav-item">
                            <a class="nav-link" href="<?php echo url('login.php'); ?>">
                                <i class="fas fa-sign-in-alt me-1"></i> Connexion
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </nav>
</body>
</html>