<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
require_once 'includes/init.php';
requireLogin();
require_once 'includes/header.php';

// Récupération des statistiques
$stats = [
    'pieces_total' => 0,
    'pieces_refs' => 0,
    'events_a_venir' => 0,
    'clients_actifs' => 0
];

try {
    // Nombre total de pièces (somme des stocks)
    $stmt = $db->query("SELECT SUM(stock_permanent) as total FROM pieces");
    $stats['pieces_total'] = $stmt->fetchColumn() ?: 0;

    // Nombre de références distinctes
    $stmt = $db->query("SELECT COUNT(*) FROM pieces");
    $stats['pieces_refs'] = $stmt->fetchColumn();

    // Événements à venir (prochaine année)
    $stmt = $db->query("SELECT COUNT(*) FROM events WHERE date_debut >= CURDATE() AND date_debut <= DATE_ADD(CURDATE(), INTERVAL 1 YEAR) AND statut != 'annule'");
    $stats['events_a_venir'] = $stmt->fetchColumn();

    // Clients actifs (ayant des événements non annulés)
    $stmt = $db->query("SELECT COUNT(DISTINCT client_nom) FROM events WHERE statut != 'annule'");
    $stats['clients_actifs'] = $stmt->fetchColumn();

} catch(PDOException $e) {
    addMessage("Erreur lors de la récupération des statistiques", "error");
    logActivity('error', $e->getMessage());
}
?>

<style>
/* Mobile-First Responsive Design */
.dashboard-cards {
    display: grid;
    grid-template-columns: 1fr 1fr;
    gap: 1rem;
    margin-bottom: 2rem;
}

@media (min-width: 768px) {
    .dashboard-cards {
        grid-template-columns: repeat(4, 1fr);
    }
}

.stat-card {
    background: white;
    border-radius: 12px;
    padding: 1.5rem;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    border: none;
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}

.stat-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
}

.stat-card .card-icon {
    font-size: 2.5rem;
    margin-bottom: 1rem;
}

.stat-card .card-number {
    font-size: 2rem;
    font-weight: bold;
    margin-bottom: 0.5rem;
}

.stat-card .card-label {
    color: #6c757d;
    font-size: 0.9rem;
    margin-bottom: 1rem;
}

.stat-card .btn {
    width: 100%;
    border-radius: 8px;
    font-weight: 500;
}

/* Cards responsives avec icônes colorées */
.card-stock { border-left: 5px solid #0d6efd; }
.card-stock .card-icon { color: #0d6efd; }

.card-events { border-left: 5px solid #198754; }
.card-events .card-icon { color: #198754; }

.card-clients { border-left: 5px solid #6f42c1; }
.card-clients .card-icon { color: #6f42c1; }

.card-actions { border-left: 5px solid #fd7e14; }
.card-actions .card-icon { color: #fd7e14; }

/* Section Événements à Venir */
.events-section {
    background: white;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    margin-bottom: 2rem;
}

.events-header {
    background: linear-gradient(135deg, #198754, #20c997);
    color: white;
    padding: 1.5rem;
    border-radius: 12px 12px 0 0;
    margin-bottom: 0;
}

/* Mobile: Cards pour événements */
.event-card {
    border: none;
    border-bottom: 1px solid #e9ecef;
    border-radius: 0;
    margin-bottom: 0;
}

.event-card:last-child {
    border-bottom: none;
    border-radius: 0 0 12px 12px;
}

.event-status {
    padding: 0.25rem 0.75rem;
    border-radius: 20px;
    font-size: 0.8rem;
    font-weight: 500;
}

.status-preparation { background-color: #fff3cd; color: #856404; }
.status-en_cours { background-color: #d4edda; color: #155724; }
.status-termine { background-color: #d1ecf1; color: #0c5460; }
.status-annule { background-color: #f8d7da; color: #721c24; }

/* Desktop: Tableau pour événements */
@media (min-width: 992px) {
    .events-mobile { display: none; }
    .events-desktop { display: block; }
}

@media (max-width: 991px) {
    .events-mobile { display: block; }
    .events-desktop { display: none; }
}

.event-actions {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.event-actions .btn {
    flex: 1;
    min-width: 80px;
}

/* FAB (Floating Action Button) pour mobile */
.fab {
    position: fixed;
    bottom: 2rem;
    right: 2rem;
    background: #fd7e14;
    color: white;
    border: none;
    border-radius: 50%;
    width: 60px;
    height: 60px;
    font-size: 1.5rem;
    box-shadow: 0 4px 20px rgba(253,126,20,0.4);
    z-index: 1050;
    transition: all 0.3s ease;
}

.fab:hover {
    background: #e8681a;
    transform: scale(1.1);
}

@media (min-width: 768px) {
    .fab { display: none; }
}

/* Actions rapides desktop */
.quick-actions {
    display: flex;
    gap: 0.5rem;
    flex-wrap: wrap;
}

.quick-actions .btn {
    flex: 1;
    white-space: nowrap;
}

@media (max-width: 767px) {
    .quick-actions { display: none; }
}

/* CSS pour bouton purple custom */
.text-purple { color: #6f42c1; }
.btn-outline-purple {
    color: #6f42c1;
    border-color: #6f42c1;
}
.btn-outline-purple:hover {
    background-color: #6f42c1;
    border-color: #6f42c1;
    color: white;
}
</style>

<div class="container-fluid mt-4">
    <div class="row">
        <div class="col-12">
            <h1 class="mb-4">
                <i class="fas fa-tachometer-alt me-2"></i>Dashboard BeMatrix
            </h1>
            
            <!-- Cartes de Statistiques -->
            <div class="dashboard-cards">
                <!-- Carte Stock -->
                <div class="stat-card card-stock">
                    <div class="card-icon">
                        <i class="fas fa-box"></i>
                    </div>
                    <div class="card-number text-primary">
                        <?php echo e($stats['pieces_total']); ?>
                    </div>
                    <div class="card-label">
                        pièces en stock (<?php echo e($stats['pieces_refs']); ?> références)
                    </div>
                    <a href="<?php echo url('stock/pieces.php'); ?>" class="btn btn-primary">
                        <i class="fas fa-cogs me-1"></i>Gérer le stock
                    </a>
                </div>

                <!-- Carte Événements à Venir -->
                <div class="stat-card card-events">
                    <div class="card-icon">
                        <i class="fas fa-calendar-plus"></i>
                    </div>
                    <div class="card-number text-success">
                        <?php echo e($stats['events_a_venir']); ?>
                    </div>
                    <div class="card-label">
                        événements à venir (1 an)
                    </div>
                    <a href="<?php echo url('events/liste.php'); ?>" class="btn btn-success">
                        <i class="fas fa-calendar-alt me-1"></i>Voir planning
                    </a>
                </div>

                <!-- Carte Clients -->
                <div class="stat-card card-clients">
                    <div class="card-icon">
                        <i class="fas fa-users"></i>
                    </div>
                    <div class="card-number text-purple">
                        <?php echo e($stats['clients_actifs']); ?>
                    </div>
                    <div class="card-label">
                        clients actifs
                    </div>
                    <button class="btn btn-outline-purple" onclick="voirClients()">
                        <i class="fas fa-address-book me-1"></i>Voir clients
                    </button>
                </div>

                <!-- Carte Actions Rapides -->
                <div class="stat-card card-actions">
                    <div class="card-icon">
                        <i class="fas fa-bolt"></i>
                    </div>
                    <div class="card-number text-warning">
                        <i class="fas fa-tools"></i>
                    </div>
                    <div class="card-label">
                        actions rapides
                    </div>
                    <div class="quick-actions">
                        <button class="btn btn-warning btn-sm" onclick="nouvelEvenement()">
                            <i class="fas fa-plus me-1"></i>Événement
                        </button>
                    </div>
                </div>
            </div>

            <!-- Section Événements à Venir -->
            <div class="events-section">
                <div class="events-header">
                    <h5 class="mb-0">
                        <i class="fas fa-calendar-week me-2"></i>Événements à Venir
                        <small class="opacity-75 ms-2">(prochaine année)</small>
                    </h5>
                </div>

                <!-- Version Mobile: Cards -->
                <div class="events-mobile">
                    <?php
                    try {
                        $query = "
                            SELECT e.*, 
                                   COUNT(es.id) as nb_stands,
                                   SUM(es.prix_total_ht) as total_ht
                            FROM events e
                            LEFT JOIN event_stands es ON e.id = es.event_id
                            WHERE e.date_debut >= CURDATE() 
                            AND e.date_debut <= DATE_ADD(CURDATE(), INTERVAL 1 YEAR)
                            AND e.statut != 'annule'
                            GROUP BY e.id
                            ORDER BY e.date_debut ASC
                            LIMIT 20
                        ";
                        $stmt = $db->query($query);
                        $events = $stmt->fetchAll(PDO::FETCH_ASSOC);

                        foreach($events as $event): ?>
                            <div class="event-card p-3">
                                <div class="d-flex justify-content-between align-items-start mb-2">
                                    <div class="form-check">
                                        <input class="form-check-input" type="checkbox" 
                                               value="<?php echo $event['id']; ?>" 
                                               id="event_<?php echo $event['id']; ?>">
                                        <label class="form-check-label fw-bold" for="event_<?php echo $event['id']; ?>">
                                            <?php echo e($event['nom']); ?>
                                        </label>
                                    </div>
                                    <span class="event-status status-<?php echo $event['statut']; ?>">
                                        <?php echo ucfirst($event['statut']); ?>
                                    </span>
                                </div>
                                
                                <div class="row g-2 mb-3">
                                    <div class="col-6">
                                        <small class="text-muted">
                                            <i class="fas fa-calendar me-1"></i>
                                            <?php echo date('d/m/Y', strtotime($event['date_debut'])); ?>
                                            <?php if($event['date_debut'] != $event['date_fin']): ?>
                                                - <?php echo date('d/m', strtotime($event['date_fin'])); ?>
                                            <?php endif; ?>
                                        </small>
                                    </div>
                                    <div class="col-6">
                                        <small class="text-muted">
                                            <i class="fas fa-map-marker-alt me-1"></i>
                                            <?php echo e($event['lieu']); ?>
                                        </small>
                                    </div>
                                </div>

                                <div class="mb-3">
                                    <div class="fw-semibold">
                                        <i class="fas fa-building me-1"></i>
                                        <?php echo e($event['client_nom']); ?>
                                    </div>
                                    <?php if($event['nb_stands'] > 0): ?>
                                        <small class="text-muted">
                                            <?php echo $event['nb_stands']; ?> stand(s)
                                            <?php if($event['total_ht'] && $event['total_ht'] > 0): ?>
                                                • <?php echo number_format($event['total_ht'], 0); ?>€ HT
                                            <?php endif; ?>
                                        </small>
                                    <?php endif; ?>
                                </div>

                                <div class="event-actions">
                                    <button class="btn btn-outline-primary btn-sm" 
                                            onclick="voirEvent(<?php echo $event['id']; ?>)">
                                        <i class="fas fa-eye me-1"></i>Voir
                                    </button>
                                    <button class="btn btn-outline-secondary btn-sm"
                                            onclick="modifierEvent(<?php echo $event['id']; ?>)">
                                        <i class="fas fa-edit me-1"></i>Modifier
                                    </button>
                                </div>
                            </div>
                        <?php endforeach;

                        if (empty($events)): ?>
                            <div class="p-4 text-center">
                                <i class="fas fa-calendar-times text-muted mb-3" style="font-size: 3rem;"></i>
                                <h5 class="text-muted">Aucun événement à venir</h5>
                                <p class="text-muted mb-3">Aucun événement prévu dans la prochaine année</p>
                                <button class="btn btn-success" onclick="nouvelEvenement()">
                                    <i class="fas fa-plus me-2"></i>Créer un événement
                                </button>
                            </div>
                        <?php endif;

                    } catch(PDOException $e) {
                        echo '<div class="p-4 text-center text-danger">Erreur lors de la récupération des événements</div>';
                        logActivity('error', $e->getMessage());
                    }
                    ?>
                </div>

                <!-- Version Desktop: Tableau -->
                <div class="events-desktop">
                    <div class="table-responsive">
                        <table class="table table-hover mb-0">
                            <thead class="table-light">
                                <tr>
                                    <th width="50">
                                        <input type="checkbox" class="form-check-input" id="selectAll">
                                    </th>
                                    <th>Événement</th>
                                    <th>Client</th>
                                    <th>Dates</th>
                                    <th>Lieu</th>
                                    <th>Stands</th>
                                    <th>Statut</th>
                                    <th width="150">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php
                                // Requête pour la version desktop
                                try {
                                    $query_desktop = "
                                        SELECT e.*, 
                                               COUNT(es.id) as nb_stands,
                                               SUM(es.prix_total_ht) as total_ht
                                        FROM events e
                                        LEFT JOIN event_stands es ON e.id = es.event_id
                                        WHERE e.date_debut >= CURDATE() 
                                        AND e.date_debut <= DATE_ADD(CURDATE(), INTERVAL 1 YEAR)
                                        AND e.statut != 'annule'
                                        GROUP BY e.id
                                        ORDER BY e.date_debut ASC
                                        LIMIT 20
                                    ";
                                    $stmt = $db->query($query_desktop);
                                    $events = $stmt->fetchAll(PDO::FETCH_ASSOC);
                                    
                                    foreach($events as $event): ?>
                                        <tr>
                                            <td>
                                                <input type="checkbox" class="form-check-input event-checkbox" 
                                                       value="<?php echo $event['id']; ?>">
                                            </td>
                                            <td>
                                                <strong><?php echo e($event['nom']); ?></strong>
                                            </td>
                                            <td>
                                                <?php echo e($event['client_nom']); ?>
                                                <?php if($event['client_contact']): ?>
                                                    <br><small class="text-muted">
                                                        <?php echo e($event['client_contact']); ?>
                                                    </small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php echo date('d/m/Y', strtotime($event['date_debut'])); ?>
                                                <?php if($event['date_debut'] != $event['date_fin']): ?>
                                                    <br><small class="text-muted">
                                                        au <?php echo date('d/m/Y', strtotime($event['date_fin'])); ?>
                                                    </small>
                                                <?php endif; ?>
                                            </td>
                                            <td><?php echo e($event['lieu']); ?></td>
                                            <td class="text-center">
                                                <?php if($event['nb_stands'] > 0): ?>
                                                    <span class="badge bg-info">
                                                        <?php echo $event['nb_stands']; ?>
                                                    </span>
                                                    <?php if($event['total_ht'] && $event['total_ht'] > 0): ?>
                                                        <br><small class="text-muted">
                                                            <?php echo number_format($event['total_ht'], 0); ?>€
                                                        </small>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <span class="event-status status-<?php echo $event['statut']; ?>">
                                                    <?php echo ucfirst($event['statut']); ?>
                                                </span>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <button class="btn btn-outline-primary" 
                                                            onclick="voirEvent(<?php echo $event['id']; ?>)"
                                                            title="Voir détails">
                                                        <i class="fas fa-eye"></i>
                                                    </button>
                                                    <button class="btn btn-outline-secondary"
                                                            onclick="modifierEvent(<?php echo $event['id']; ?>)"
                                                            title="Modifier">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach;

                                    if (empty($events)): ?>
                                        <tr>
                                            <td colspan="8" class="text-center py-5">
                                                <i class="fas fa-calendar-times text-muted mb-3" style="font-size: 3rem;"></i>
                                                <h5 class="text-muted">Aucun événement à venir</h5>
                                                <button class="btn btn-success mt-2" onclick="nouvelEvenement()">
                                                    <i class="fas fa-plus me-2"></i>Créer un événement
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endif;

                                } catch(PDOException $e) {
                                    echo '<tr><td colspan="8" class="text-center text-danger py-4">Erreur lors de la récupération des événements</td></tr>';
                                }
                                ?>
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Actions groupées (desktop) -->
                    <?php if(!empty($events)): ?>
                        <div class="p-3 border-top bg-light">
                            <div class="d-flex justify-content-between align-items-center">
                                <small class="text-muted">
                                    <span id="selectedCount">0</span> événement(s) sélectionné(s)
                                </small>
                                <div class="btn-group btn-group-sm" id="groupActions" style="display: none;">
                                    <button class="btn btn-primary" onclick="exportSelection()">
                                        <i class="fas fa-download me-1"></i>Exporter
                                    </button>
                                    <button class="btn btn-info" onclick="envoyerEmails()">
                                        <i class="fas fa-envelope me-1"></i>Envoyer email
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- FAB Mobile -->
<button class="fab" onclick="toggleQuickActions()" title="Actions rapides">
    <i class="fas fa-plus"></i>
</button>

<script>
// Gestion sélection multiple
document.addEventListener('DOMContentLoaded', function() {
    const selectAll = document.getElementById('selectAll');
    const checkboxes = document.querySelectorAll('.event-checkbox');
    const selectedCount = document.getElementById('selectedCount');
    const groupActions = document.getElementById('groupActions');

    // Sélectionner tout
    if(selectAll) {
        selectAll.addEventListener('change', function() {
            checkboxes.forEach(cb => {
                cb.checked = this.checked;
            });
            updateSelection();
        });
    }

    // Gestion sélection individuelle
    checkboxes.forEach(cb => {
        cb.addEventListener('change', updateSelection);
    });

    function updateSelection() {
        const selected = document.querySelectorAll('.event-checkbox:checked, .form-check-input:checked[id^="event_"]');
        if(selectedCount) selectedCount.textContent = selected.length;
        
        if(groupActions) {
            groupActions.style.display = selected.length > 0 ? 'block' : 'none';
        }
    }
});

// Actions
function voirEvent(id) {
    window.location.href = '<?php echo url("events/detail.php"); ?>?id=' + id;
}

function modifierEvent(id) {
    window.location.href = '<?php echo url("events/modifier.php"); ?>?id=' + id;
}

function nouvelEvenement() {
    window.location.href = '<?php echo url("events/creation.php"); ?>';
}

function voirClients() {
    window.location.href = '<?php echo url("clients/"); ?>';
}

function toggleQuickActions() {
    // Menu mobile des actions rapides
    const actions = [
        { icon: 'fas fa-plus', text: 'Nouvel événement', action: 'nouvelEvenement()' },
        { icon: 'fas fa-qrcode', text: 'Scanner QR (bientôt)', action: 'alert("Fonctionnalité QR Code à venir")' },
        { icon: 'fas fa-users', text: 'Voir clients', action: 'voirClients()' }
    ];
    
    // Créer menu contextuel (à améliorer avec un vrai modal)
    let menu = actions.map(a => 
        `<button class="btn btn-light mb-2 w-100" onclick="${a.action}">
            <i class="${a.icon} me-2"></i>${a.text}
        </button>`
    ).join('');
    
    alert('Actions rapides:\n- Nouvel événement\n- Scanner QR (bientôt)\n- Voir clients');
}

function exportSelection() {
    const selected = document.querySelectorAll('.event-checkbox:checked, .form-check-input:checked[id^="event_"]');
    const ids = Array.from(selected).map(cb => cb.value);
    
    if(ids.length === 0) {
        alert('Veuillez sélectionner au moins un événement');
        return;
    }
    
    // Simulation export - à remplacer par vraie logique
    alert(`Export de ${ids.length} événement(s) (IDs: ${ids.join(', ')})`);
}

function envoyerEmails() {
    const selected = document.querySelectorAll('.event-checkbox:checked, .form-check-input:checked[id^="event_"]');
    const ids = Array.from(selected).map(cb => cb.value);
    
    if(ids.length === 0) {
        alert('Veuillez sélectionner au moins un événement');
        return;
    }
    
    alert(`Envoi d'emails pour ${ids.length} événement(s) - fonction à implémenter`);
}
</script>

<?php require_once 'includes/footer.php'; ?>