﻿<?php
require_once '../includes/init.php';
requireLogin();
require_once '../includes/header.php';

try {
    // Initialisation
    $stats = [
        'total_demandes' => 0,
        'demandes_actives' => 0,
        'pieces_manquantes' => 0
    ];

    // 1. Analyse des pièces manquantes
    $query_pieces = "
        SELECT 
            p.id,
            p.reference,
            p.designation,
            p.stock_permanent,
            COUNT(DISTINCT s.id) as nb_stands,
            (COUNT(DISTINCT s.id) - p.stock_permanent) as manquant
        FROM pieces p
        JOIN stand_type_pieces stp ON p.id = stp.piece_id
        JOIN stand_types st ON stp.stand_id = st.id
        JOIN stands s ON s.type_id = st.id
        JOIN event_stands es ON s.id = es.stand_id
        JOIN events e ON es.event_id = e.id
        WHERE e.statut = 'preparation'
        GROUP BY p.id, p.reference, p.designation, p.stock_permanent
        HAVING nb_stands > p.stock_permanent
        ORDER BY manquant DESC";

    $stmt = $db->query($query_pieces);
    $pieces_manquantes = $stmt->fetchAll(PDO::FETCH_ASSOC);
    $stats['pieces_manquantes'] = count($pieces_manquantes);
    $top_pieces = array_slice($pieces_manquantes, 0, 10);

    // 2. Analyse des événements
    $query_events = "
        SELECT 
            e.id,
            e.nom as event_nom,
            e.date_debut,
            COUNT(DISTINCT p.id) as nb_pieces,
            COUNT(DISTINCT CASE 
                WHEN COUNT(DISTINCT s.id) OVER (PARTITION BY p.id) > p.stock_permanent 
                THEN p.id 
            END) as nb_demandes,
            SUM(
                CASE 
                    WHEN COUNT(DISTINCT s.id) > p.stock_permanent 
                    THEN COUNT(DISTINCT s.id) - p.stock_permanent 
                    ELSE 0 
                END
            ) as total_pieces_manquantes
        FROM events e
        JOIN event_stands es ON e.id = es.event_id
        JOIN stands s ON es.stand_id = s.id
        JOIN stand_types st ON s.type_id = st.id
        JOIN stand_type_pieces stp ON st.id = stp.stand_id
        JOIN pieces p ON stp.piece_id = p.id
        WHERE e.statut = 'preparation'
        GROUP BY e.id, e.nom, e.date_debut";

    $stmt = $db->query($query_events);
    $evenements = $stmt->fetchAll(PDO::FETCH_ASSOC);

    // 3. Comptage des demandes actives
    $query_actives = "
        SELECT COUNT(*) 
        FROM demandes_location 
        WHERE statut IN ('a_commander', 'commande', 'confirme')";
    $stats['demandes_actives'] = $db->query($query_actives)->fetchColumn();

    // 4. Calcul du total des demandes
    $stats['total_demandes'] = count($evenements);

} catch(PDOException $e) {
    addMessage("Erreur lors de la récupération des données: " . $e->getMessage(), "error");
    logActivity('error', $e->getMessage());
    $evenements = [];
    $top_pieces = [];
    $stats = [
        'total_demandes' => 0,
        'demandes_actives' => 0,
        'pieces_manquantes' => 0
    ];
}
?>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>Analyse des besoins BE Matrix</h1>
        <div>
            <button type="button" class="btn btn-success" onclick="exportToExcel()">
                <i class="fas fa-file-excel me-2"></i>Exporter Excel
            </button>
        </div>
    </div>

    <!-- Cartes statistiques -->
    <div class="row mb-4">
        <div class="col-md-3">
            <div class="card bg-primary text-white">
                <div class="card-body">
                    <h6 class="card-title">Total des demandes</h6>
                    <h2 class="mb-0"><?php echo $stats['total_demandes']; ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h6 class="card-title">Demandes actives</h6>
                    <h2 class="mb-0"><?php echo $stats['demandes_actives']; ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-warning">
                <div class="card-body">
                    <h6 class="card-title">Pièces manquantes</h6>
                    <h2 class="mb-0"><?php echo $stats['pieces_manquantes']; ?></h2>
                </div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="card bg-info text-white">
                <div class="card-body">
                    <h6 class="card-title">Taux de couverture</h6>
                    <h2 class="mb-0">
                        <?php 
                        $taux = $stats['total_demandes'] > 0 
                            ? round((($stats['total_demandes'] - $stats['pieces_manquantes']) / $stats['total_demandes']) * 100) 
                            : 100;
                        echo $taux . '%';
                        ?>
                    </h2>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Analyse par événement -->
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Besoins par événement</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table">
                            <thead>
                                <tr>
                                    <th>Événement</th>
                                    <th>Date</th>
                                    <th>Pièces diff.</th>
                                    <th>Demandes</th>
                                    <th>Total pièces</th>
                                    <th>Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($evenements as $evt): ?>
                                    <tr>
                                        <td><?php echo e($evt['event_nom']); ?></td>
                                        <td><?php echo date('d/m/Y', strtotime($evt['date_debut'])); ?></td>
                                        <td class="text-center"><?php echo $evt['nb_pieces']; ?></td>
                                        <td class="text-center"><?php echo $evt['nb_demandes']; ?></td>
                                        <td class="text-center"><?php echo $evt['total_pieces_manquantes']; ?></td>
                                        <td>
                                            <a href="detail_event.php?id=<?php echo $evt['id']; ?>" 
                                               class="btn btn-sm btn-outline-primary">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- Top pièces -->
        <div class="col-md-4">
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Top pièces les plus demandées</h5>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-sm">
                            <thead>
                                <tr>
                                    <th>Référence</th>
                                    <th>Stock</th>
                                    <th>Manquant</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($top_pieces as $piece): ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo e($piece['reference']); ?></strong><br>
                                            <small class="text-muted"><?php echo e($piece['designation']); ?></small>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-secondary">
                                                <?php echo $piece['stock_permanent']; ?>
                                            </span>
                                        </td>
                                        <td class="text-center">
                                            <span class="badge bg-warning">
                                                <?php echo $piece['manquant']; ?>
                                            </span>
                                        </td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function exportToExcel() {
    alert('Fonctionnalité d\'export Excel à implémenter');
}
</script>

<?php require_once '../includes/footer.php'; ?>