﻿<?php
require_once '../includes/init.php';
requireLogin();
require_once '../includes/header.php';

// Récupération de l'ID de la demande
$id = filter_input(INPUT_GET, 'id', FILTER_VALIDATE_INT);

if (!$id) {
    addMessage("ID de demande invalide", "error");
    header('Location: ' . url('location/liste.php'));
    exit;
}

try {
    // Récupération des détails de la demande
    $query = "
        SELECT 
            dl.*,
            e.nom as event_nom,
            e.date_debut as event_date,
            e.lieu as event_lieu,
            p.reference as piece_reference,
            p.designation as piece_designation,
            p.stock_permanent as stock_actuel,
            p.image_principale
        FROM demandes_location dl
        LEFT JOIN events e ON m.evenement_id = e.id
        JOIN pieces p ON dl.piece_id = p.id
        WHERE dl.id = :id
    ";
    
    $stmt = $db->prepare($query);
    $stmt->execute(['id' => $id]);
    $demande = $stmt->fetch(PDO::FETCH_ASSOC);

    if (!$demande) {
        throw new Exception("Demande non trouvée");
    }

    // Définition des statuts et classes
    $statusClass = [
        'a_commander' => 'warning',
        'commande' => 'info',
        'confirme' => 'primary',
        'livre' => 'success',
        'retourne' => 'secondary'
    ];
    
    $statusText = [
        'a_commander' => 'À commander',
        'commande' => 'Commandé',
        'confirme' => 'Confirmé',
        'livre' => 'Livré',
        'retourne' => 'Retourné'
    ];

} catch(Exception $e) {
    addMessage("Erreur lors de la récupération de la demande: " . $e->getMessage(), "error");
    header('Location: ' . url('location/liste.php'));
    exit;
}
?>

<div class="container mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <div>
            <h1 class="mb-0">Demande BE Matrix #<?php echo $id; ?></h1>
            <p class="text-muted mb-0">
                Créée le <?php echo date('d/m/Y H:i', strtotime($demande['date_demande'])); ?>
            </p>
        </div>
        <div>
            <a href="<?php echo url('location/liste.php'); ?>" class="btn btn-outline-secondary me-2">
                <i class="fas fa-arrow-left me-2"></i>Retour
            </a>
            <?php if($demande['statut'] != 'retourne'): ?>
                <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#modalUpdateStatus">
                    <i class="fas fa-edit me-2"></i>Modifier le statut
                </button>
            <?php endif; ?>
        </div>
    </div>

    <div class="row">
        <!-- Informations principales -->
        <div class="col-md-8">
            <div class="card mb-4">
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <h5 class="card-title">Événement</h5>
                            <div class="card mb-3 bg-light">
                                <div class="card-body">
                                    <h6 class="card-subtitle"><?php echo e($demande['event_nom']); ?></h6>
                                    <p class="card-text">
                                        <i class="fas fa-calendar-alt me-2"></i>
                                        <?php echo date('d/m/Y', strtotime($demande['event_date'])); ?>
                                    </p>
                                    <p class="card-text">
                                        <i class="fas fa-map-marker-alt me-2"></i>
                                        <?php echo e($demande['event_lieu']); ?>
                                    </p>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <h5 class="card-title">Pièce</h5>
                            <div class="card mb-3 bg-light">
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-auto">
                                            <?php if($demande['image_principale']): ?>
                                                <img src="<?php echo url('uploads/pieces/' . $demande['image_principale']); ?>" 
                                                     alt="<?php echo e($demande['piece_reference']); ?>"
                                                     class="img-thumbnail"
                                                     style="width: 80px; height: 80px; object-fit: cover;">
                                            <?php else: ?>
                                                <div class="bg-secondary text-white d-flex align-items-center justify-content-center" 
                                                     style="width: 80px; height: 80px;">
                                                    <i class="fas fa-cube fa-2x"></i>
                                                </div>
                                            <?php endif; ?>
                                        </div>
                                        <div class="col">
                                            <h6 class="card-subtitle"><?php echo e($demande['piece_reference']); ?></h6>
                                            <p class="card-text"><?php echo e($demande['piece_designation']); ?></p>
                                            <p class="card-text">
                                                <small class="text-muted">
                                                    Stock actuel: <?php echo e($demande['stock_actuel']); ?>
                                                </small>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-4">
                            <h6>Quantité demandée</h6>
                            <span class="badge bg-primary"><?php echo e($demande['quantite_demandee']); ?></span>
                        </div>
                        <div class="col-md-4">
                            <h6>Statut actuel</h6>
                            <span class="badge bg-<?php echo $statusClass[$demande['statut']]; ?>">
                                <?php echo $statusText[$demande['statut']]; ?>
                            </span>
                        </div>
                        <div class="col-md-4">
                            <h6>Référence commande</h6>
                            <?php if($demande['reference_commande']): ?>
                                <span class="badge bg-info"><?php echo e($demande['reference_commande']); ?></span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Historique -->
            <div class="card">
                <div class="card-header">
                    <h5 class="mb-0">Historique des modifications</h5>
                </div>
                <div class="card-body">
                    <div class="timeline">
                        <?php
                        // Ici, vous pourriez ajouter une requête pour récupérer l'historique des modifications
                        // Pour l'instant, on affiche juste la création
                        ?>
                        <div class="timeline-item">
                            <div class="timeline-point bg-success">
                                <i class="fas fa-plus"></i>
                            </div>
                            <div class="timeline-content">
                                <h6>Création de la demande</h6>
                                <p class="text-muted mb-0">
                                    <?php echo date('d/m/Y H:i', strtotime($demande['date_demande'])); ?>
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Panneau latéral -->
        <div class="col-md-4">
            <!-- Dates importantes -->
            <div class="card mb-4">
                <div class="card-header">
                    <h5 class="mb-0">Dates importantes</h5>
                </div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <li class="list-group-item">
                            <div class="d-flex justify-content-between align-items-center">
                                <div>
                                    <i class="fas fa-calendar-day me-2"></i>
                                    Date de besoin
                                </div>
                                <strong><?php echo date('d/m/Y', strtotime($demande['date_besoin'])); ?></strong>
                            </div>
                        </li>
                        <?php if($demande['date_retour_prevu']): ?>
                            <li class="list-group-item">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div>
                                        <i class="fas fa-calendar-check me-2"></i>
                                        Retour prévu
                                    </div>
                                    <strong><?php echo date('d/m/Y', strtotime($demande['date_retour_prevu'])); ?></strong>
                                </div>
                            </li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Mise à jour statut -->
<div class="modal fade" id="modalUpdateStatus" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form action="update_status.php" method="POST">
                <input type="hidden" name="demande_id" value="<?php echo $id; ?>">
                
                <div class="modal-header">
                    <h5 class="modal-title">Modifier le statut</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Nouveau statut</label>
                        <select name="nouveau_statut" class="form-select" required>
                            <?php foreach($statusText as $key => $text): ?>
                                <option value="<?php echo $key; ?>" <?php echo $demande['statut'] == $key ? 'selected' : ''; ?>>
                                    <?php echo $text; ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Référence commande</label>
                        <input type="text" name="reference_commande" class="form-control" 
                               value="<?php echo e($demande['reference_commande']); ?>">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Commentaire</label>
                        <textarea name="commentaire" class="form-control" rows="3"></textarea>
                    </div>
                </div>
                
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Annuler</button>
                    <button type="submit" class="btn btn-primary">Enregistrer</button>
                </div>
            </form>
        </div>
    </div>
</div>

<?php require_once '../includes/footer.php'; ?>