﻿<?php
$page_title = "Alertes de stock";
require_once '../includes/header.php';
requireLogin();

try {
    // Récupération des pièces sous le seuil minimum
    $query = "SELECT 
        p.*, 
        c.nom as categorie_nom,
        (SELECT COUNT(*) FROM events_pieces ep 
         LEFT JOIN events e ON m.evenement_id = e.id
         WHERE ep.piece_id = p.id AND e.statut IN ('preparation', 'en_cours')) as nb_reservations
    FROM pieces p
    LEFT JOIN categories c ON p.categorie_id = c.id
    WHERE p.stock_permanent < p.stock_minimum
    ORDER BY (p.stock_minimum - p.stock_permanent) DESC";
    
    $pieces = $db->query($query)->fetchAll();
    
    // Statistiques des alertes
    $stats = [
        'total_alertes' => count($pieces),
        'stock_critique' => 0,  // Stock <= 25% du minimum
        'stock_bas' => 0       // Stock <= 50% du minimum
    ];
    
    foreach ($pieces as $piece) {
        $ratio = $piece['stock_permanent'] / max(1, $piece['stock_minimum']);
        if ($ratio <= 0.25) {
            $stats['stock_critique']++;
        } elseif ($ratio <= 0.50) {
            $stats['stock_bas']++;
        }
    }
    
} catch (PDOException $e) {
    error_log("Erreur dans alertes.php: " . $e->getMessage());
    $pieces = [];
    $stats = ['total_alertes' => 0, 'stock_critique' => 0, 'stock_bas' => 0];
}
?>

<div class="container my-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h1>
            <i class="fas fa-exclamation-triangle text-warning me-2"></i>
            Alertes de stock
            <span class="badge bg-warning text-dark ms-2">
                <?= $stats['total_alertes'] ?> alerte<?= $stats['total_alertes'] > 1 ? 's' : '' ?>
            </span>
        </h1>
    </div>

    <!-- Statistiques -->
    <div class="row mb-4">
        <div class="col-md-4">
            <div class="card border-warning h-100">
                <div class="card-body">
                    <h5 class="card-title text-warning">
                        <i class="fas fa-exclamation-circle me-2"></i>
                        Total des alertes
                    </h5>
                    <h2 class="mb-0"><?= $stats['total_alertes'] ?></h2>
                    <small class="text-muted">pièces sous le seuil minimum</small>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card border-danger h-100">
                <div class="card-body">
                    <h5 class="card-title text-danger">
                        <i class="fas fa-radiation me-2"></i>
                        Stock critique
                    </h5>
                    <h2 class="mb-0"><?= $stats['stock_critique'] ?></h2>
                    <small class="text-muted">≤ 25% du seuil minimum</small>
                </div>
            </div>
        </div>
        
        <div class="col-md-4">
            <div class="card border-warning h-100">
                <div class="card-body">
                    <h5 class="card-title text-warning">
                        <i class="fas fa-arrow-down me-2"></i>
                        Stock bas
                    </h5>
                    <h2 class="mb-0"><?= $stats['stock_bas'] ?></h2>
                    <small class="text-muted">≤ 50% du seuil minimum</small>
                </div>
            </div>
        </div>
    </div>

    <?php if (!empty($pieces)): ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead class="table-light">
                    <tr>
                        <th>Référence</th>
                        <th>Désignation</th>
                        <th>Catégorie</th>
                        <th class="text-end">Stock actuel</th>
                        <th class="text-end">Stock minimum</th>
                        <th class="text-end">Manquant</th>
                        <th class="text-end">Réservations</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($pieces as $piece): ?>
                        <?php 
                        $ratio = $piece['stock_permanent'] / max(1, $piece['stock_minimum']);
                        $rowClass = $ratio <= 0.25 ? 'table-danger' : ($ratio <= 0.50 ? 'table-warning' : '');
                        $manquant = max(0, $piece['stock_minimum'] - $piece['stock_permanent']);
                        ?>
                        <tr class="<?= $rowClass ?>">
                            <td><strong><?= e($piece['reference']) ?></strong></td>
                            <td><?= e($piece['designation']) ?></td>
                            <td><?= e($piece['categorie_nom']) ?></td>
                            <td class="text-end">
                                <span class="badge bg-secondary">
                                    <?= $piece['stock_permanent'] ?>
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="badge bg-info">
                                    <?= $piece['stock_minimum'] ?>
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="badge bg-danger">
                                    <?= $manquant ?>
                                </span>
                            </td>
                            <td class="text-end">
                                <span class="badge bg-warning text-dark">
                                    <?= $piece['nb_reservations'] ?>
                                </span>
                            </td>
                            <td>
                                <div class="btn-group">
                                    <a href="<?= url('stock/pieces.php?id=' . $piece['id']) ?>" 
                                       class="btn btn-sm btn-outline-primary"
                                       title="Voir la pièce">
                                        <i class="fas fa-eye"></i>
                                    </a>
                                    <a href="<?= url('mouvements/entree.php?piece_id=' . $piece['id']) ?>" 
                                       class="btn btn-sm btn-outline-success"
                                       title="Entrée stock">
                                        <i class="fas fa-plus"></i>
                                    </a>
                                </div>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    <?php else: ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle me-2"></i>
            Aucune pièce n'est sous le seuil minimum de stock.
        </div>
    <?php endif; ?>
</div>

<?php require_once '../includes/footer.php'; ?>